package edu.cmu.cs.cs214.blockingqueue;
public interface BlockingQueue<E> {

	/**
	 * Enqueues an element at the back of the queue if there is space in the 
	 * bounded queue, or blocks (and later enqueues the item) if there is not space.
	 * 
	 * @param e  The element to be enqueued.
	 */
	public void enqueue(E e);

	/**
	 * Removes and returns the element from the front of the queue if the queue
	 * is not empty, or blocks (and eventually removes and returns the front element) 
	 * if the queue is empty.
	 * 
	 * @return  The item removed from the front of the queue.
	 */
	public E dequeue();

}